<?php
session_start();

// If user is already logged in, redirect to dashboard
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: index.html');
    exit;
}

$error = '';

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    $valid_username = 'admin';
    $valid_password = 'Acad1234';
    
    if ($username === $valid_username && $password === $valid_password) {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_username'] = $username;
        $_SESSION['login_time'] = time();
        
        header('Location: index.html');
        exit;
    } else {
        $error = 'Invalid username or password';
    }
}
?>
<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - AcadLib</title>
    <style>
        /* ===== VARIABLES & THEME ===== */
        :root {
            /* Colors - Modern Gradient Palette */
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --primary-light: #4895ef;
            --secondary: #7209b7;
            --accent: #f72585;
            --success: #4cc9f0;
            --warning: #f8961e;
            --danger: #f94144;
            --info: #560bad;
            
            /* Neutral Colors */
            --dark: #1a1d29;
            --dark-2: #2d3042;
            --gray-dark: #4a4e69;
            --gray: #6c757d;
            --gray-light: #8d99ae;
            --gray-lighter: #edf2f4;
            --light: #f8f9fa;
            --white: #ffffff;
            
            /* Gradients */
            --gradient-primary: linear-gradient(135deg, var(--primary), var(--secondary));
            --gradient-accent: linear-gradient(135deg, var(--accent), var(--warning));
            --gradient-dark: linear-gradient(135deg, var(--dark), var(--dark-2));
            --gradient-success: linear-gradient(135deg, var(--success), var(--primary-light));
            
            /* Backgrounds */
            --bg-primary: #0f1117;
            --bg-secondary: #1a1d29;
            --bg-card: #2d3042;
            --bg-sidebar: #1e212e;
            --bg-hover: #363a4d;
            
            /* Borders & Shadows */
            --border-radius: 0.75rem;
            --border-radius-lg: 1rem;
            --border-radius-xl: 1.5rem;
            --border: 1px solid rgba(255, 255, 255, 0.1);
            --border-light: 1px solid rgba(255, 255, 255, 0.05);
            
            /* Shadows - Glassmorphism */
            --shadow-sm: 0 2px 8px rgba(0, 0, 0, 0.1);
            --shadow-md: 0 8px 25px rgba(0, 0, 0, 0.15);
            --shadow-lg: 0 15px 40px rgba(0, 0, 0, 0.2);
            --shadow-xl: 0 25px 50px rgba(0, 0, 0, 0.25);
            --shadow-glow: 0 0 20px rgba(67, 97, 238, 0.3);
            
            /* Transitions */
            --transition-fast: 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            --transition-normal: 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            --transition-slow: 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            
            /* Glassmorphism */
            --glass-bg: rgba(45, 48, 66, 0.7);
            --glass-border: rgba(255, 255, 255, 0.1);
            --glass-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', 'Segoe UI', system-ui, sans-serif;
            background: var(--bg-primary);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--gray-lighter);
            background-image: 
                radial-gradient(at 0% 0%, rgba(67, 97, 238, 0.15) 0px, transparent 50%),
                radial-gradient(at 100% 0%, rgba(114, 9, 183, 0.15) 0px, transparent 50%),
                radial-gradient(at 100% 100%, rgba(247, 37, 133, 0.1) 0px, transparent 50%);
        }
        
        .login-container {
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            padding: 3rem;
            border-radius: var(--border-radius-xl);
            box-shadow: var(--shadow-xl);
            width: 100%;
            max-width: 420px;
            position: relative;
            overflow: hidden;
        }

        .login-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--primary), var(--secondary), var(--accent));
        }
        
        .logo {
            text-align: center;
            margin-bottom: 2.5rem;
        }
        
        .logo img {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            object-fit: cover;
            margin-bottom: 1.5rem;
            border: 3px solid rgba(255, 255, 255, 0.1);
            box-shadow: var(--shadow-glow);
            transition: all var(--transition-normal);
        }

        .logo img:hover {
            transform: scale(1.05);
            box-shadow: 0 0 30px rgba(67, 97, 238, 0.5);
        }
        
        .logo h1 {
            background: linear-gradient(135deg, var(--white), var(--primary-light));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            font-size: 1.75rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .logo p {
            color: var(--gray-light);
            font-size: 0.95rem;
            font-weight: 500;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            color: var(--gray-lighter);
            font-weight: 600;
            text-align: left;
            font-size: 0.95rem;
        }
        
        .form-group input {
            width: 100%;
            padding: 0.875rem 1rem;
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: var(--border-radius);
            font-size: 1rem;
            transition: all var(--transition-normal);
            background: rgba(255, 255, 255, 0.05);
            color: var(--white);
            font-family: inherit;
        }

        .form-group input::placeholder {
            color: var(--gray-light);
        }
        
        .form-group input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2), var(--shadow-md);
            background: rgba(255, 255, 255, 0.08);
        }
        
        .btn-login {
            width: 100%;
            padding: 0.875rem;
            background: var(--gradient-primary);
            color: var(--white);
            border: none;
            border-radius: var(--border-radius);
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all var(--transition-normal);
            box-shadow: var(--shadow-glow);
            position: relative;
            overflow: hidden;
            margin-top: 0.5rem;
        }

        .btn-login::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left var(--transition-normal);
        }

        .btn-login:hover::before {
            left: 100%;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(67, 97, 238, 0.4);
        }

        .btn-login:active {
            transform: translateY(0);
        }
        
        .error-message {
            background: rgba(249, 65, 68, 0.1);
            color: var(--danger);
            padding: 0.875rem;
            border-radius: var(--border-radius);
            margin-bottom: 1.5rem;
            text-align: center;
            border: 1px solid rgba(249, 65, 68, 0.3);
            font-weight: 500;
        }
        
        .login-footer {
            text-align: center;
            margin-top: 2rem;
            color: var(--gray-light);
            font-size: 0.875rem;
            font-weight: 500;
        }

        .forgot-password {
            text-align: center;
            margin-top: 1rem;
        }

        .forgot-password a {
            color: var(--primary-light);
            text-decoration: none;
            font-size: 0.875rem;
            font-weight: 500;
            transition: color var(--transition-fast);
        }

        .forgot-password a:hover {
            color: var(--primary);
            text-decoration: underline;
        }

        .language-switcher {
            position: absolute;
            top: 1.5rem;
            right: 1.5rem;
        }

        .lang-btn {
            background: rgba(255, 255, 255, 0.1);
            color: var(--gray-lighter);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 0.5rem 1rem;
            border-radius: 1rem;
            cursor: pointer;
            backdrop-filter: blur(10px);
            font-size: 0.875rem;
            font-weight: 500;
            transition: all var(--transition-fast);
        }

        .lang-btn:hover {
            background: rgba(255, 255, 255, 0.15);
            border-color: rgba(255, 255, 255, 0.3);
        }
    </style>
</head>
<body>
    
    
    <div class="login-container">
        <div class="logo">
            <img src="https://www.acadlib.com/app-panel/api/uploads/logo.png" alt="AcadLib Logo">
            <h1>AcadLib Dashboard</h1>
        
        </div>
        
        <?php if ($error): ?>
            <div class="error-message">
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <div class="form-group">
                <label for="username">Username:</label>
                <input type="text" id="username" name="username" required autofocus placeholder="Enter your username">
            </div>
            
            <div class="form-group">
                <label for="password">Password:</label>
                <input type="password" id="password" name="password" required placeholder="Enter your password">
            </div>
            
            <button type="submit" class="btn-login">Login</button>
        </form>

        
        
        
    </div>

    <script>
        function switchLanguage() {
            // Switch to Arabic version
            window.location.href = 'login-ar.php';
        }

        function showForgotPassword() {
            alert('Please contact system administrator to reset your password.);
        }

        // Add some interactive effects
        document.addEventListener('DOMContentLoaded', function() {
            const inputs = document.querySelectorAll('input');
            inputs.forEach(input => {
                input.addEventListener('focus', function() {
                    this.parentElement.style.transform = 'scale(1.02)';
                });
                
                input.addEventListener('blur', function() {
                    this.parentElement.style.transform = 'scale(1)';
                });
            });

            // Add enter key support
            document.getElementById('password').addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    document.querySelector('form').submit();
                }
            });

            // Add floating animation to logo
            const logo = document.querySelector('.logo img');
            let floating = true;
            
            function floatLogo() {
                if (floating) {
                    logo.style.transform = 'translateY(-5px)';
                    setTimeout(() => {
                        logo.style.transform = 'translateY(5px)';
                    }, 1500);
                }
            }
            
            setInterval(floatLogo, 3000);
        });
    </script>
</body>
</html>