<?php
session_start();

function checkAdminSession() {
    if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
        return false;
    }
    
    // التحقق من انتهاء الجلسة (30 دقيقة)
    $session_duration = 30 * 60;
    if (isset($_SESSION['login_time']) && (time() - $_SESSION['login_time'] > $session_duration)) {
        session_destroy();
        return false;
    }
    
    // تجديد وقت الجلسة
    $_SESSION['login_time'] = time();
    return true;
}

// للاستخدام في ملفات API
if (isset($_GET['check_session'])) {
    header('Content-Type: application/json');
    echo json_encode(['logged_in' => checkAdminSession()]);
    exit;
}
?>