<?php
include 'config.php';

header('Content-Type: application/json; charset=utf-8');

// GET: Get analytics data
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    try {
        error_log("=== ANALYTICS REQUEST ===");
        
        // إحصائيات الكتب
        $booksStmt = $pdo->query('
            SELECT 
                COUNT(*) as total_books,
                SUM(is_protected) as protected_books,
                SUM(is_external) as external_books,
                AVG(file_size) as avg_file_size,
                SUM(file_size) as total_storage
            FROM books
        ');
        $booksStats = $booksStmt->fetch(PDO::FETCH_ASSOC);
        
        // إحصائيات التصنيفات
        $categoriesStmt = $pdo->query('SELECT COUNT(*) as total_categories FROM categories');
        $categoriesStats = $categoriesStmt->fetch(PDO::FETCH_ASSOC);
        
        // إحصائيات تصنيفات البروفايل
        $profileCategoriesStmt = $pdo->query('
            SELECT 
                COUNT(*) as total_categories,
                SUM(is_active) as active_categories
            FROM profile_categories
        ');
        $profileCategoriesStats = $profileCategoriesStmt->fetch(PDO::FETCH_ASSOC);
        
        // التصنيف الأكثر استخداماً
        $popularCategoryStmt = $pdo->query('
            SELECT c.name, COUNT(b.id) as book_count
            FROM categories c
            LEFT JOIN books b ON c.id = b.category_id
            GROUP BY c.id, c.name
            ORDER BY book_count DESC
            LIMIT 1
        ');
        $popularCategory = $popularCategoryStmt->fetch(PDO::FETCH_ASSOC);
        
        // الكتب المحمية
        $protectedBooksStmt = $pdo->query('
            SELECT b.*, c.name as category_name, pc.name as profile_category_name
            FROM books b
            LEFT JOIN categories c ON b.category_id = c.id
            LEFT JOIN profile_categories pc ON b.profile_category_id = pc.id
            WHERE b.is_protected = 1
            ORDER BY b.created_at DESC
        ');
        $protectedBooks = $protectedBooksStmt->fetchAll(PDO::FETCH_ASSOC);
        
        // تجهيز البيانات للاستجابة
        $response = [
            'books' => [
                'total' => (int)$booksStats['total_books'],
                'protected' => (int)$booksStats['protected_books'],
                'external' => (int)$booksStats['external_books'],
                'avg_file_size' => (float)$booksStats['avg_file_size'],
                'total_storage' => (float)$booksStats['total_storage']
            ],
            'categories' => [
                'total' => (int)$categoriesStats['total_categories'],
                'most_used' => $popularCategory ? [
                    'name' => $popularCategory['name'],
                    'book_count' => (int)$popularCategory['book_count']
                ] : null
            ],
            'profile_categories' => [
                'total' => (int)$profileCategoriesStats['total_categories'],
                'active' => (int)$profileCategoriesStats['active_categories']
            ],
            'protected_books' => $protectedBooks
        ];
        
        // حساب النسب المئوية
        if ($booksStats['total_books'] > 0) {
            $response['percentages'] = [
                'protected' => round(($booksStats['protected_books'] / $booksStats['total_books']) * 100, 1),
                'external' => round(($booksStats['external_books'] / $booksStats['total_books']) * 100, 1)
            ];
        } else {
            $response['percentages'] = [
                'protected' => 0,
                'external' => 0
            ];
        }
        
        error_log("✅ Analytics data prepared successfully");
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
        
    } catch (PDOException $e) {
        error_log("❌ Database error in analytics: " . $e->getMessage());
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    }
    exit();
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
?>