<?php
// تحسين إعدادات الذاكرة والوقت لملفات PDF الكبيرة
ini_set('memory_limit', '512M');
ini_set('max_execution_time', 300);
ini_set('upload_max_filesize', '100M');
ini_set('post_max_size', '100M');
ini_set('max_input_time', 300);

// CORS headers - وضعها في البداية
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, Accept');
header('Access-Control-Max-Age: 86400');
header('Content-Type: application/json; charset=utf-8');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// إعدادات قاعدة البيانات - معلوماتك الحقيقية
$host = 'localhost';
$dbname = 'admin_acadlibapp';
$username = 'admin_acadlib';
$password = '!PK7IHqG76';

// الاتصال بقاعدة البيانات
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'فشل في الاتصال بقاعدة البيانات: ' . $e->getMessage()]);
    exit();
}


// 🔥 اكتشاف وتصحيح مشاكل LiteSpeed
function is_litespeed_server() {
    return (isset($_SERVER['SERVER_SOFTWARE']) && 
            stripos($_SERVER['SERVER_SOFTWARE'], 'LiteSpeed') !== false);
}

if (is_litespeed_server()) {
    // إعدادات خاصة بـ LiteSpeed
    ini_set('display_errors', '0');
    ini_set('log_errors', '1');
    error_log("🚀 LiteSpeed Server Detected - Applying fixes");
    
    // تنظيف أي إخراج قديم
    if (ob_get_length()) ob_clean();
}

// في ملف config.php - تحديث دالة createTables()
function createTables($pdo) {
    try {
        // جدول التصنيفات العادية (للهوم سكرين) - محدث
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS categories (
                id INT AUTO_INCREMENT PRIMARY KEY,
                name VARCHAR(255) NOT NULL,
                image_url VARCHAR(500) NOT NULL DEFAULT '',
                description TEXT,
                display_order INT DEFAULT 0,
                is_active BOOLEAN DEFAULT TRUE,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
        ");
        
        // جدول تصنيفات البروفايل (للبروفايل سكرين)
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS profile_categories (
                id INT AUTO_INCREMENT PRIMARY KEY,
                name VARCHAR(255) NOT NULL,
                image_url VARCHAR(500) NOT NULL DEFAULT '',
                description TEXT,
                display_order INT DEFAULT 0,
                is_active BOOLEAN DEFAULT TRUE,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
        ");
        
        // تحديث جدول الكتب لإضافة الحقول الجديدة
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS books (
                id INT AUTO_INCREMENT PRIMARY KEY,
                title VARCHAR(255) NOT NULL,
                author VARCHAR(255) DEFAULT '',
                institution VARCHAR(255) DEFAULT '',
                publication_year VARCHAR(10) DEFAULT '',
                keywords TEXT,
                category_id INT NOT NULL,
                profile_category_id INT,
                image_url VARCHAR(500) NOT NULL DEFAULT '',
                summary TEXT NOT NULL,
                pdf_url VARCHAR(500) NOT NULL DEFAULT '',
                original_pdf_url VARCHAR(500) NOT NULL DEFAULT '', -- 🔥 الجديد: لحفظ الملف الأصلي دائماً
                extracted_pdf_url VARCHAR(500) NOT NULL DEFAULT '',
                extracted_summary_pdf_url VARCHAR(500) NOT NULL DEFAULT '',
                is_external_plus BOOLEAN DEFAULT FALSE, -- 🔥 NEW: External Link Plus flag
                file_size INT DEFAULT 0,
                extracted_file_size INT DEFAULT 0,
                extracted_summary_file_size INT DEFAULT 0,
                page_count INT DEFAULT 0,
                is_external BOOLEAN DEFAULT FALSE,
                table_of_contents TEXT,
                selected_pages_summary VARCHAR(255),
                selected_pages_toc VARCHAR(255),
                selected_pages_original VARCHAR(255),
                language VARCHAR(50) DEFAULT '', -- 🔥 NEW: Language PDF field
                format VARCHAR(100) DEFAULT '', -- 🔥 NEW: Format field
                
                -- الحقول الجديدة للحماية
                is_protected BOOLEAN DEFAULT FALSE,
                protection_key VARCHAR(255) DEFAULT '',
                
                -- الحقول الجديدة للتحكم في زر القراءة
                show_read_button BOOLEAN DEFAULT TRUE,
                read_button_text VARCHAR(50) DEFAULT 'Lire le document',
                
                -- الحقول الجديدة للتحكم في حجم الملف
                custom_file_size VARCHAR(100) DEFAULT '',
                show_file_size BOOLEAN DEFAULT TRUE,
                
                -- الحقل الجديد: Taille befor Extrait
                taille_before_extrait VARCHAR(100) DEFAULT '',
                show_taille_before_extrait BOOLEAN DEFAULT TRUE,
                
                -- NEW: Download Extrait button control fields
                show_download_extrait_button BOOLEAN DEFAULT TRUE,
                download_extrait_button_text VARCHAR(50) DEFAULT 'Download extrait',
                
                -- 🔥 NEW: Download counter
                download_count INT DEFAULT 0,
                
                -- 🔥 NEW: Stockage field
                stockage VARCHAR(255) DEFAULT '',
                
                -- 🔥 NEW: External download link fields
                external_download_link VARCHAR(500) DEFAULT '',
                show_external_download_button BOOLEAN DEFAULT FALSE,
                
                -- 🔥 NEW: External download protection fields
                external_download_protection_key VARCHAR(255) DEFAULT '',
                is_external_download_protected BOOLEAN DEFAULT FALSE,
                
                -- 🔥 NEW: Active status field for books
                is_active BOOLEAN DEFAULT TRUE,
                
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                FOREIGN KEY (category_id) REFERENCES categories(id),
                FOREIGN KEY (profile_category_id) REFERENCES profile_categories(id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
        ");

        // 🔥 NEW: جدول إعدادات الاتصال - محدث بإضافة العنوان
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS contact_settings (
                id INT AUTO_INCREMENT PRIMARY KEY,
                phone_number VARCHAR(50) DEFAULT '+212612345678',
                whatsapp_number VARCHAR(50) DEFAULT '+212612345678',
                email VARCHAR(255) DEFAULT 'admin@watchevents.shop',
                company_name VARCHAR(255) DEFAULT 'WatchEvents Administration',
                company_address TEXT, -- 🔥 NEW: Added address field
                business_hours TEXT,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
        ");

        // 🔥 NEW: جدول إعدادات النصوص للشاشات
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS screen_texts (
                id INT AUTO_INCREMENT PRIMARY KEY,
                screen_name VARCHAR(100) NOT NULL UNIQUE,
                title_text TEXT,
                description_text TEXT,
                show_welcome_section BOOLEAN DEFAULT TRUE, -- 🔥 NEW: Control welcome section visibility
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
        ");

        // إضافة الحقول الجديدة إذا لم تكن موجودة للكتب
        $newColumns = [
            'institution' => 'VARCHAR(255) DEFAULT ""',
            'publication_year' => 'VARCHAR(10) DEFAULT ""',
            'keywords' => 'TEXT',
            'selected_pages_summary' => 'VARCHAR(255) DEFAULT ""',
            'selected_pages_toc' => 'VARCHAR(255) DEFAULT ""',
            'selected_pages_original' => 'VARCHAR(255) DEFAULT ""',
            'extracted_summary_pdf_url' => 'VARCHAR(500) DEFAULT ""',
            'extracted_summary_file_size' => 'INT DEFAULT 0',
            'is_protected' => 'BOOLEAN DEFAULT FALSE',
            'protection_key' => 'VARCHAR(255) DEFAULT ""',
            'show_read_button' => 'BOOLEAN DEFAULT TRUE',
            'read_button_text' => 'VARCHAR(50) DEFAULT "Lire le document"',
            'is_external_plus' => 'BOOLEAN DEFAULT FALSE', // 🔥 NEW
            'custom_file_size' => 'VARCHAR(100) DEFAULT ""',
            'show_file_size' => 'BOOLEAN DEFAULT TRUE',
            'taille_before_extrait' => 'VARCHAR(100) DEFAULT ""',
            'show_taille_before_extrait' => 'BOOLEAN DEFAULT TRUE',
            // NEW: Download Extrait button fields
            'show_download_extrait_button' => 'BOOLEAN DEFAULT TRUE',
            'download_extrait_button_text' => 'VARCHAR(50) DEFAULT "Download extrait"',
            // 🔥 الجديد: حقل الملف الأصلي
            'original_pdf_url' => 'VARCHAR(500) DEFAULT ""',
            // 🔥 NEW: Download counter
            'download_count' => 'INT DEFAULT 0',
            // 🔥 NEW: Stockage field
            'stockage' => 'VARCHAR(255) DEFAULT ""',
            // 🔥 NEW: Language PDF field
            'language' => 'VARCHAR(50) DEFAULT ""',
            // 🔥 NEW: Format field
            'format' => 'VARCHAR(100) DEFAULT ""',
            // 🔥 NEW: External download link fields
            'external_download_link' => 'VARCHAR(500) DEFAULT ""',
            'show_external_download_button' => 'BOOLEAN DEFAULT FALSE',
            // 🔥 NEW: External download protection fields
            'external_download_protection_key' => 'VARCHAR(255) DEFAULT ""',
            'is_external_download_protected' => 'BOOLEAN DEFAULT FALSE',
            // 🔥 NEW: Active status field for books
            'is_active' => 'BOOLEAN DEFAULT TRUE',
			
			'require_login_for_download' => 'BOOLEAN DEFAULT FALSE'
        ];

        foreach ($newColumns as $column => $definition) {
            try {
                $pdo->exec("ALTER TABLE books ADD COLUMN $column $definition");
                error_log("✅ Added column $column to books table");
            } catch (PDOException $e) {
                if (strpos($e->getMessage(), 'Duplicate column name') === false) {
                    error_log("❌ Error adding column $column: " . $e->getMessage());
                } else {
                    error_log("ℹ️ Column $column already exists");
                }
            }
        }
        
        // إضافة الحقول الجديدة لجدول categories إذا لم تكن موجودة
        $newCategoryColumns = [
            'description' => 'TEXT',
            'display_order' => 'INT DEFAULT 0',
            'is_active' => 'BOOLEAN DEFAULT TRUE'
        ];

        foreach ($newCategoryColumns as $column => $definition) {
            try {
                $pdo->exec("ALTER TABLE categories ADD COLUMN $column $definition");
                error_log("✅ Added column $column to categories table");
            } catch (PDOException $e) {
                if (strpos($e->getMessage(), 'Duplicate column name') === false) {
                    error_log("❌ Error adding column $column: " . $e->getMessage());
                } else {
                    error_log("ℹ️ Column $column already exists in categories");
                }
            }
        }
        
        // إضافة الحقل إذا لم يكن موجوداً
        try {
            $pdo->exec("ALTER TABLE screen_texts ADD COLUMN show_welcome_section BOOLEAN DEFAULT TRUE");
            error_log("✅ Added show_welcome_section column to screen_texts");
        } catch (PDOException $e) {
            if (strpos($e->getMessage(), 'Duplicate column name') === false) {
                error_log("❌ Error adding show_welcome_section: " . $e->getMessage());
            } else {
                error_log("ℹ️ Column show_welcome_section already exists");
            }
        }
        
        // 🔥 NEW: إضافة حقل العنوان إلى contact_settings إذا لم يكن موجوداً
        try {
            $pdo->exec("ALTER TABLE contact_settings ADD COLUMN company_address TEXT");
            error_log("✅ Added company_address column to contact_settings");
        } catch (PDOException $e) {
            if (strpos($e->getMessage(), 'Duplicate column name') === false) {
                error_log("❌ Error adding company_address: " . $e->getMessage());
            } else {
                error_log("ℹ️ Column company_address already exists");
            }
        }
        
        // 🔥 تحديث الكتب الحالية: تعيين original_pdf_url إذا كان فارغاً
        try {
            $pdo->exec("UPDATE books SET original_pdf_url = pdf_url WHERE original_pdf_url = '' OR original_pdf_url IS NULL");
            error_log("✅ Updated existing books with original_pdf_url");
        } catch (PDOException $e) {
            error_log("ℹ️ Note: Could not update existing books: " . $e->getMessage());
        }
        
        // 🔥 NEW: تحديث الكتب الحالية: تعيين is_active = TRUE إذا كان NULL
        try {
            $pdo->exec("UPDATE books SET is_active = TRUE WHERE is_active IS NULL");
            error_log("✅ Updated existing books with is_active = TRUE");
        } catch (PDOException $e) {
            error_log("ℹ️ Note: Could not update existing books is_active: " . $e->getMessage());
        }
        
        // 🔥 تحديث التصنيفات الحالية: تعيين القيم الافتراضية للحقول الجديدة
        try {
            $pdo->exec("UPDATE categories SET display_order = 0 WHERE display_order IS NULL");
            $pdo->exec("UPDATE categories SET is_active = TRUE WHERE is_active IS NULL");
            error_log("✅ Updated existing categories with new fields");
        } catch (PDOException $e) {
            error_log("ℹ️ Note: Could not update existing categories: " . $e->getMessage());
        }
        
        // 🔥 NEW: إضافة إعدادات الاتصال الافتراضية إذا لم تكن موجودة
        try {
            $stmt = $pdo->query("SELECT COUNT(*) FROM contact_settings");
            if ($stmt->fetchColumn() == 0) {
                $pdo->exec("INSERT INTO contact_settings (phone_number, whatsapp_number, email, company_name, company_address, business_hours) VALUES 
                    ('+212612345678', '+212612345678', 'admin@watchevents.shop', 'WatchEvents Administration', 'Casablanca, Morocco',
                    'Monday - Friday: 09:00 - 18:00\nSaturday: 10:00 - 16:00\nSunday: Closed')");
                error_log("✅ Default contact settings inserted with address");
            }
        } catch (PDOException $e) {
            error_log("ℹ️ Note: Could not insert default contact settings: " . $e->getMessage());
        }
        
        // 🔥 NEW: إضافة النصوص الافتراضية للشاشات
        try {
            $defaultTexts = [
                [
                    'screen_name' => 'home_screen',
                    'title_text' => 'Bienvenue',
                    'description_text' => 'Découvrez notre collection de livres PDF organisée par catégories. Trouvez facilement ce que vous cherchez et commencez à lire instantanément.'
                ],
                [
                    'screen_name' => 'profile_screen', 
                    'title_text' => 'Mémoire de fin d\'études',
                    'description_text' => 'Découvrez notre collection de Mémoire de fin d\'études PDF organisée par catégories. Trouvez facilement ce que vous cherchez et commencez à lire instantanément.'
                ]
            ];
            
            foreach ($defaultTexts as $text) {
                $stmt = $pdo->prepare("
                    INSERT IGNORE INTO screen_texts (screen_name, title_text, description_text) 
                    VALUES (?, ?, ?)
                ");
                $stmt->execute([$text['screen_name'], $text['title_text'], $text['description_text']]);
            }
            
            error_log("✅ Default screen texts inserted successfully");
        } catch (PDOException $e) {
            error_log("ℹ️ Default texts already exist or could not be inserted: " . $e->getMessage());
        }
        
        // 🔥 NEW: Update existing books to set empty language field
        try {
            $pdo->exec("UPDATE books SET language = '' WHERE language IS NULL");
            error_log("✅ Updated existing books with empty language field");
        } catch (PDOException $e) {
            error_log("ℹ️ Note: Could not update language field: " . $e->getMessage());
        }

        // 🔥 NEW: Update existing books to set empty format field
        try {
            $pdo->exec("UPDATE books SET format = '' WHERE format IS NULL");
            error_log("✅ Updated existing books with empty format field");
        } catch (PDOException $e) {
            error_log("ℹ️ Note: Could not update format field: " . $e->getMessage());
        }

        // 🔥 NEW: Update existing books to set default values for external download link fields
        try {
            $pdo->exec("UPDATE books SET external_download_link = '' WHERE external_download_link IS NULL");
            $pdo->exec("UPDATE books SET show_external_download_button = FALSE WHERE show_external_download_button IS NULL");
            $pdo->exec("UPDATE books SET external_download_protection_key = '' WHERE external_download_protection_key IS NULL");
            $pdo->exec("UPDATE books SET is_external_download_protected = FALSE WHERE is_external_download_protected IS NULL");
            error_log("✅ Updated existing books with default external download link and protection values");
        } catch (PDOException $e) {
            error_log("ℹ️ Note: Could not update external download link fields: " . $e->getMessage());
        }
        
        error_log("✅ Database tables created/updated successfully with all new fields");
        
    } catch(PDOException $e) {
        error_log("❌ Table creation error: " . $e->getMessage());
        throw $e;
    }
}

// دالة لترقية جدول المفضلة
function upgradeFavoritesTable($pdo) {
    try {
        $newColumns = [
            'language' => 'TEXT DEFAULT ""', // 🔥 NEW: Language field for favorites
            'format' => 'VARCHAR(100) DEFAULT ""', // 🔥 NEW: Format field for favorites
            'is_active' => 'BOOLEAN DEFAULT TRUE', // 🔥 NEW: Active status for favorites
        ];

        foreach ($newColumns as $column => $definition) {
            try {
                $pdo->exec("ALTER TABLE favorites ADD COLUMN $column $definition");
                error_log("✅ Added column $column to favorites table");
            } catch (PDOException $e) {
                if (strpos($e->getMessage(), 'Duplicate column name') === false) {
                    error_log("❌ Error adding column $column to favorites: " . $e->getMessage());
                } else {
                    error_log("ℹ️ Column $column already exists in favorites");
                }
            }
        }
    } catch (PDOException $e) {
        error_log("❌ Favorites table upgrade error: " . $e->getMessage());
    }
}

// استدعاء الدالة لإنشاء الجداول
createTables($pdo);

// ترقية جدول المفضلة إذا لزم الأمر
upgradeFavoritesTable($pdo);

// دالة للتحقق من وجود جميع الحقول المطلوبة
function verifyDatabaseStructure($pdo) {
    try {
        $requiredColumns = [
            'language', 'format', 'stockage', 'download_count', 'original_pdf_url', 
            'show_download_extrait_button', 'download_extrait_button_text',
            'taille_before_extrait', 'show_taille_before_extrait',
            'external_download_link', 'show_external_download_button', // 🔥 NEW: External download link fields
            'external_download_protection_key', 'is_external_download_protected', // 🔥 NEW: External download protection fields
            'description', 'display_order', 'is_active', // 🔥 NEW: Added category fields
            'is_active' // 🔥 NEW: Added book active status field
        ];
        
        $missingColumns = [];
        
        foreach ($requiredColumns as $column) {
            try {
                $stmt = $pdo->prepare("SELECT $column FROM books LIMIT 1");
                $stmt->execute();
            } catch (PDOException $e) {
                if (strpos($e->getMessage(), 'Unknown column') !== false) {
                    $missingColumns[] = $column;
                }
            }
        }
        
        if (!empty($missingColumns)) {
            error_log("⚠️ Missing columns detected: " . implode(', ', $missingColumns));
            error_log("🔄 Attempting to add missing columns...");
            
            // إعادة محاولة إضافة الحقول المفقودة
            createTables($pdo);
        } else {
            error_log("✅ All required database columns are present");
        }
        
    } catch (PDOException $e) {
        error_log("❌ Database structure verification error: " . $e->getMessage());
    }
}

// التحقق من هيكل قاعدة البيانات
verifyDatabaseStructure($pdo);

// دالة مساعدة للحصول على معلومات قاعدة البيانات
function getDatabaseInfo($pdo) {
    try {
        // الحصول على معلومات الجداول
        $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
        
        $info = [
            'tables' => $tables,
            'books_columns' => [],
            'categories_columns' => [],
            'favorites_columns' => []
        ];
        
        // الحصول على أعمدة جدول الكتب
        $stmt = $pdo->query("DESCRIBE books");
        $info['books_columns'] = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        // الحصول على أعمدة جدول التصنيفات
        $stmt = $pdo->query("DESCRIBE categories");
        $info['categories_columns'] = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        // الحصول على أعمدة جدول المفضلة إذا كان موجوداً
        try {
            $stmt = $pdo->query("DESCRIBE favorites");
            $info['favorites_columns'] = $stmt->fetchAll(PDO::FETCH_COLUMN);
        } catch (PDOException $e) {
            error_log("ℹ️ Favorites table not available for inspection");
        }
        
        error_log("📊 Database Info:");
        error_log("   Tables: " . implode(', ', $info['tables']));
        error_log("   Books columns count: " . count($info['books_columns']));
        error_log("   Categories columns count: " . count($info['categories_columns']));
        error_log("   Language field in books: " . (in_array('language', $info['books_columns']) ? 'YES' : 'NO'));
        error_log("   Format field in books: " . (in_array('format', $info['books_columns']) ? 'YES' : 'NO')); // 🔥 NEW: Format check
        error_log("   Description field in categories: " . (in_array('description', $info['categories_columns']) ? 'YES' : 'NO'));
        error_log("   Display_order field in categories: " . (in_array('display_order', $info['categories_columns']) ? 'YES' : 'NO'));
        error_log("   Is_active field in categories: " . (in_array('is_active', $info['categories_columns']) ? 'YES' : 'NO'));
        error_log("   Is_active field in books: " . (in_array('is_active', $info['books_columns']) ? 'YES' : 'NO')); // 🔥 NEW: Book active status check
        error_log("   External_download_link field in books: " . (in_array('external_download_link', $info['books_columns']) ? 'YES' : 'NO')); // 🔥 NEW
        error_log("   Show_external_download_button field in books: " . (in_array('show_external_download_button', $info['books_columns']) ? 'YES' : 'NO')); // 🔥 NEW
        error_log("   External_download_protection_key field in books: " . (in_array('external_download_protection_key', $info['books_columns']) ? 'YES' : 'NO')); // 🔥 NEW
        error_log("   Is_external_download_protected field in books: " . (in_array('is_external_download_protected', $info['books_columns']) ? 'YES' : 'NO')); // 🔥 NEW
        
        return $info;
        
    } catch (PDOException $e) {
        error_log("❌ Database info error: " . $e->getMessage());
        return null;
    }
}

// الحصول على معلومات قاعدة البيانات للتصحيح
getDatabaseInfo($pdo);

// دالة لترقية الإصدار
function upgradeDatabaseVersion($pdo, $newVersion) {
    try {
        // إنشاء جدول إصدارات قاعدة البيانات إذا لم يكن موجوداً
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS database_versions (
                id INT AUTO_INCREMENT PRIMARY KEY,
                version INT NOT NULL,
                upgrade_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                description TEXT
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
        ");
        
        // الحصول على الإصدار الحالي
        $stmt = $pdo->query("SELECT MAX(version) as current_version FROM database_versions");
        $currentVersion = $stmt->fetch(PDO::FETCH_ASSOC)['current_version'] ?? 0;
        
        if ($newVersion > $currentVersion) {
            // تسجيل الإصدار الجديد
            $stmt = $pdo->prepare("INSERT INTO database_versions (version, description) VALUES (?, ?)");
            $stmt->execute([$newVersion, "Added Book Active Status field"]);
            
            error_log("✅ Database upgraded to version $newVersion");
        } else {
            error_log("ℹ️ Database is already at version $currentVersion");
        }
        
    } catch (PDOException $e) {
        error_log("❌ Database version upgrade error: " . $e->getMessage());
    }
}

// ترقية إصدار قاعدة البيانات
upgradeDatabaseVersion($pdo, 23); // 🔥 NEW: Version 23 with Book Active Status field

// دالة لتنظيف قاعدة البيانات (لأغراض التطوير فقط)
function cleanupDatabase($pdo) {
    try {
        // حذف الكتب التي ليس لها عنوان
        $stmt = $pdo->prepare("DELETE FROM books WHERE title IS NULL OR title = ''");
        $deleted = $stmt->execute();
        
        if ($deleted) {
            error_log("✅ Cleaned up invalid books from database");
        }
        
    } catch (PDOException $e) {
        error_log("❌ Database cleanup error: " . $e->getMessage());
    }
}

// تنظيف قاعدة البيانات (تعليق في الإنتاج)
// cleanupDatabase($pdo);

// دالة لإنشاء فهرس للأداء
function createIndexes($pdo) {
    try {
        // إنشاء فهارس للاستعلامات الشائعة
        $indexes = [
            "CREATE INDEX IF NOT EXISTS idx_books_title ON books(title)",
            "CREATE INDEX IF NOT EXISTS idx_books_category ON books(category_id)",
            "CREATE INDEX IF NOT EXISTS idx_books_profile_category ON books(profile_category_id)",
            "CREATE INDEX IF NOT EXISTS idx_books_language ON books(language)", // 🔥 NEW: Index for language
            "CREATE INDEX IF NOT EXISTS idx_books_format ON books(format)", // 🔥 NEW: Index for format
            "CREATE INDEX IF NOT EXISTS idx_books_download_count ON books(download_count)",
            "CREATE INDEX IF NOT EXISTS idx_books_created_at ON books(created_at)",
            "CREATE INDEX IF NOT EXISTS idx_books_active ON books(is_active)", // 🔥 NEW: Index for active books
            "CREATE INDEX IF NOT EXISTS idx_categories_display_order ON categories(display_order)", // 🔥 NEW: Index for categories
            "CREATE INDEX IF NOT EXISTS idx_categories_active ON categories(is_active)", // 🔥 NEW: Index for active categories
            "CREATE INDEX IF NOT EXISTS idx_books_external_download ON books(show_external_download_button)", // 🔥 NEW: Index for external download button
            "CREATE INDEX IF NOT EXISTS idx_books_external_download_protected ON books(is_external_download_protected)" // 🔥 NEW: Index for external download protection
        ];
        
        foreach ($indexes as $indexSql) {
            try {
                $pdo->exec($indexSql);
                error_log("✅ Created index: $indexSql");
            } catch (PDOException $e) {
                error_log("ℹ️ Index already exists or could not be created: " . $e->getMessage());
            }
        }
        
    } catch (PDOException $e) {
        error_log("❌ Index creation error: " . $e->getMessage());
    }
}

// إنشاء الفهارس
createIndexes($pdo);

// في نهاية config.php - حدث الإصدار
upgradeDatabaseVersion($pdo, 24); // 🔥 NEW: Version 24 with Require Login for Download field

error_log("🎉 Database configuration completed successfully with Book Active Status field!");
?>