<?php
include 'config.php';

header('Content-Type: application/json; charset=utf-8');

// تفعيل التصحيح
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/debug.log');

error_log("=== DEBUG: download.php accessed ===");

// GET: Download stored PDF
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    try {
        $id = $_GET['id'] ?? null;
        
        if (!$id) {
            http_response_code(400);
            echo json_encode(['error' => 'Book ID required']);
            exit();
        }

        error_log("📥 Download request for book ID: $id");

        // جلب الكتاب من قاعدة البيانات
        $stmt = $pdo->prepare('SELECT stored_pdf_data, has_stored_pdf, is_protected, protection_key, title FROM books WHERE id = ?');
        $stmt->execute([$id]);
        $book = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$book) {
            http_response_code(404);
            echo json_encode(['error' => 'Book not found']);
            exit();
        }

        error_log("📖 Book found: {$book['title']}");
        error_log("🛡️ Has stored PDF: " . ($book['has_stored_pdf'] ? 'YES' : 'NO'));
        error_log("🔐 Book protected: " . ($book['is_protected'] ? 'YES' : 'NO'));

        // التحقق من وجود PDF مخزن
        if (!$book['has_stored_pdf'] || empty($book['stored_pdf_data'])) {
            error_log("❌ No stored PDF available");
            http_response_code(404);
            echo json_encode(['error' => 'No stored PDF available']);
            exit();
        }

        // إرجاع ملف PDF مباشرة
        $pdfData = base64_decode($book['stored_pdf_data']);
        
        if (!$pdfData) {
            error_log("❌ Failed to decode PDF data");
            http_response_code(500);
            echo json_encode(['error' => 'Failed to decode PDF data']);
            exit();
        }

        error_log("✅ Sending PDF data, size: " . strlen($pdfData) . " bytes");

        // إعداد رؤيات HTTP لتحميل الملف
        header('Content-Type: application/pdf');
        header('Content-Disposition: attachment; filename="' . $book['title'] . '.pdf"');
        header('Content-Length: ' . strlen($pdfData));
        header('Cache-Control: no-cache, no-store, must-revalidate');
        header('Pragma: no-cache');
        header('Expires: 0');

        echo $pdfData;
        exit();

    } catch (PDOException $e) {
        error_log("❌ Database error: " . $e->getMessage());
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    } catch (Exception $e) {
        error_log("❌ General error: " . $e->getMessage());
        http_response_code(500);
        echo json_encode(['error' => 'Server error: ' . $e->getMessage()]);
    }
    exit();
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
?>