<?php
// global_operations.php
include 'config.php';

// CORS headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json; charset=utf-8');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        $input = json_decode(file_get_contents('php://input'), true);
        
        if (!$input) {
            $input = $_POST;
        }
        
        $action = $input['action'] ?? '';
        $require_login_for_download = isset($input['require_login_for_download']) ? 
                                    ($input['require_login_for_download'] === true || $input['require_login_for_download'] === 'true' ? 1 : 0) : 0;

        if ($action === 'update_global_auth') {
            error_log("?? GLOBAL AUTH UPDATE: Setting require_login_for_download to $require_login_for_download for ALL books");
            
            $stmt = $pdo->prepare('UPDATE books SET require_login_for_download = ?');
            $stmt->execute([$require_login_for_download]);
            
            $updatedBooks = $stmt->rowCount();
            
            error_log("✅ Global auth update completed: $updatedBooks books updated");
            
            echo json_encode([
                'success' => true,
                'message' => "Download authentication updated for $updatedBooks books",
                'updated_books' => $updatedBooks,
                'require_login_for_download' => $require_login_for_download
            ]);
            exit;
        } else {
            http_response_code(400);
            echo json_encode(['success' => false, 'error' => 'Invalid action']);
            exit;
        }
        
    } catch (PDOException $e) {
        error_log("❌ Global operations error: " . $e->getMessage());
        http_response_code(500);
        echo json_encode(['success' => false, 'error' => 'Database error: ' . $e->getMessage()]);
        exit;
    }
}

http_response_code(405);
echo json_encode(['success' => false, 'error' => 'Method not allowed']);
?>