<?php
// CORS headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Access-Control-Max-Age: 86400');

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// الحصول على مسار الملف من query parameter
$filePath = $_GET['file'] ?? '';

if (empty($filePath)) {
    http_response_code(400);
    echo 'File path is required';
    exit();
}

// التأكد من أن الملف ضمن المجلد المسموح
$allowedDirs = ['uploads/images/', 'uploads/pdfs/'];
$isAllowed = false;

foreach ($allowedDirs as $dir) {
    if (strpos($filePath, $dir) === 0) {
        $isAllowed = true;
        break;
    }
}

if (!$isAllowed) {
    http_response_code(403);
    echo 'Access denied';
    exit();
}

// التحقق من وجود الملف
if (!file_exists($filePath)) {
    http_response_code(404);
    echo 'File not found';
    exit();
}

// تحديد نوع المحتوى
$extension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
$contentTypes = [
    'jpg' => 'image/jpeg',
    'jpeg' => 'image/jpeg',
    'png' => 'image/png',
    'gif' => 'image/gif',
    'webp' => 'image/webp',
    'pdf' => 'application/pdf'
];

if (isset($contentTypes[$extension])) {
    header('Content-Type: ' . $contentTypes[$extension]);
} else {
    header('Content-Type: application/octet-stream');
}

// إرسال الملف
readfile($filePath);
?>