<?php
// هذا الملف يعمل في الخلفية لمعالجة الملفات الثقيلة
include 'config.php';

// الحصول على المعاملات من سطر الأوامر
$bookId = $argv[1] ?? null;
$pdfPath = $argv[2] ?? '';
$selectedPages = $argv[3] ?? '';

if (!$bookId || !file_exists($pdfPath)) {
    error_log("❌ Background processing: Invalid parameters");
    exit(1);
}

error_log("🎯 Background PDF processing started for book: $bookId");

try {
    // حساب عدد الصفحات
    $pageCount = getPdfPageCountOptimized($pdfPath);
    
    // تحديث قاعدة البيانات
    $pdo->prepare('UPDATE books SET page_count = ? WHERE id = ?')
        ->execute([$pageCount, $bookId]);
    
    error_log("✅ Background processing completed for book: $bookId, Pages: $pageCount");
    
} catch (Exception $e) {
    error_log("❌ Background processing failed: " . $e->getMessage());
}
?>