<?php
include 'config.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

error_reporting(E_ALL);
ini_set('display_errors', 1);

// GET: الحصول على جميع النصوص أو نص شاشة محددة
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    try {
        $screenName = $_GET['screen_name'] ?? null;
        
        if ($screenName) {
            // الحصول على نص شاشة محددة
            $stmt = $pdo->prepare('SELECT * FROM screen_texts WHERE screen_name = ?');
            $stmt->execute([$screenName]);
            $text = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($text) {
                echo json_encode($text);
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Screen text not found']);
            }
        } else {
            // الحصول على جميع النصوص
            $stmt = $pdo->query('SELECT * FROM screen_texts ORDER BY screen_name');
            $texts = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($texts);
        }
        
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    }
    exit();
}

// POST: تحديث النصوص
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        // احصل على البيانات كـ JSON
        $jsonInput = file_get_contents('php://input');
        $input = json_decode($jsonInput, true);
        
        error_log("?? Received data: " . $jsonInput);
        
        if (!isset($input['screen_name'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Missing required field: screen_name']);
            exit();
        }
        
        $screenName = $input['screen_name'];
        $titleText = $input['title_text'] ?? '';
        $descriptionText = $input['description_text'] ?? '';
        
        // 🔥 إصلاح: تحويل boolean إلى integer لقاعدة البيانات
        $showWelcomeSection = 0; // افتراضي false
        if (isset($input['show_welcome_section'])) {
            if ($input['show_welcome_section'] === true || $input['show_welcome_section'] === 'true' || 
                $input['show_welcome_section'] === 1 || $input['show_welcome_section'] === '1') {
                $showWelcomeSection = 1; // true
            }
        }
        
        error_log("?? Processing: $screenName - show_welcome_section: " . $showWelcomeSection);
        
        // التحقق مما إذا كان النص موجوداً أم لا
        $stmt = $pdo->prepare('SELECT id FROM screen_texts WHERE screen_name = ?');
        $stmt->execute([$screenName]);
        $existing = $stmt->fetch();
        
        if ($existing) {
            // تحديث النص الموجود
            $stmt = $pdo->prepare('
                UPDATE screen_texts 
                SET title_text = ?, description_text = ?, show_welcome_section = ?, updated_at = CURRENT_TIMESTAMP 
                WHERE screen_name = ?
            ');
            $result = $stmt->execute([$titleText, $descriptionText, $showWelcomeSection, $screenName]);
            
            if ($result) {
                error_log("✅ Updated $screenName successfully - show_welcome_section: " . $showWelcomeSection);
                echo json_encode(['success' => true, 'message' => 'Screen text updated successfully']);
            } else {
                throw new Exception('Failed to update database');
            }
        } else {
            // إضافة نص جديد
            $stmt = $pdo->prepare('
                INSERT INTO screen_texts (screen_name, title_text, description_text, show_welcome_section) 
                VALUES (?, ?, ?, ?)
            ');
            $result = $stmt->execute([$screenName, $titleText, $descriptionText, $showWelcomeSection]);
            
            if ($result) {
                error_log("✅ Inserted $screenName successfully - show_welcome_section: " . $showWelcomeSection);
                echo json_encode(['success' => true, 'message' => 'Screen text added successfully']);
            } else {
                throw new Exception('Failed to insert into database');
            }
        }
        
    } catch (PDOException $e) {
        error_log("❌ Database error: " . $e->getMessage());
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    } catch (Exception $e) {
        error_log("❌ General error: " . $e->getMessage());
        http_response_code(500);
        echo json_encode(['error' => $e->getMessage()]);
    }
    exit();
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
?>