<?php
include 'config.php';

try {
    // التحقق من الاتصال بقاعدة البيانات
    $stmt = $pdo->query("SELECT 1");
    $dbStatus = 'Connected';
    
    // التحقق من وجود الجداول
    $tables = $pdo->query("SHOW TABLES LIKE 'categories'")->rowCount();
    $categoriesTable = $tables > 0 ? 'Exists' : 'Missing';
    
    $tables = $pdo->query("SHOW TABLES LIKE 'books'")->rowCount();
    $booksTable = $tables > 0 ? 'Exists' : 'Missing';
    
    echo json_encode([
        'status' => 'success',
        'message' => 'API is working correctly',
        'database' => $dbStatus,
        'tables' => [
            'categories' => $categoriesTable,
            'books' => $booksTable
        ],
        'timestamp' => date('Y-m-d H:i:s'),
        'php_version' => PHP_VERSION
    ]);
    
} catch(PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database connection failed',
        'error' => $e->getMessage(),
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}
?>