<?php
// test_pdf_extraction.php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'fpdf/fpdf.php';
require_once 'fpdi/src/autoload.php';

use setasign\Fpdi\Fpdi;

echo "<h2>PDF Extraction Test</h2>";

// دالة extractPdfPages هنا نسخ

// اختبار بسيط
try {
    echo "Testing FPDI library...<br>";
    $pdf = new Fpdi();
    echo "✅ FPDI loaded successfully<br><br>";
    
    // اختبار إنشاء PDF بسيط
    $pdf->AddPage();
    $pdf->SetFont('Arial', 'B', 16);
    $pdf->Cell(40, 10, 'Hello World!');
    $testFile = 'test_output.pdf';
    $pdf->Output($testFile, 'F');
    
    if (file_exists($testFile)) {
        echo "✅ PDF creation test passed<br>";
        unlink($testFile); // حذف ملف الاختبار
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
}

echo "<br>Test completed.";
?>