<?php
echo "<h2>Server Path Finder</h2>";
echo "<p>This will help us find where to save the .htpasswd file</p>";

echo "<h3>Server Information:</h3>";
echo "<pre>";
echo "DOCUMENT_ROOT: " . $_SERVER['DOCUMENT_ROOT'] . "\n";
echo "SCRIPT_FILENAME: " . $_SERVER['SCRIPT_FILENAME'] . "\n";
echo "Current Directory: " . __DIR__ . "\n";
echo "</pre>";

// Test common paths
$test_paths = [
    $_SERVER['DOCUMENT_ROOT'] . '/.htpasswd',
    __DIR__ . '/.htpasswd',
    '/var/www/.htpasswd',
    '/var/www/html/.htpasswd',
    '/home/' . (isset($_SERVER['USER']) ? $_SERVER['USER'] : 'username') . '/.htpasswd'
];

echo "<h3>Testing Paths:</h3>";

foreach ($test_paths as $path) {
    $test_content = "test:" . password_hash('test', PASSWORD_BCRYPT);
    $result = @file_put_contents($path, $test_content);
    
    if ($result !== false) {
        echo "<p style='color: green;'>✅ SUCCESS: Can write to: " . htmlspecialchars($path) . "</p>";
        @unlink($path); // Delete test file
    } else {
        echo "<p style='color: red;'>❌ FAILED: Cannot write to: " . htmlspecialchars($path) . "</p>";
    }
}

echo "<h3>Next Step:</h3>";
echo "<p>Copy one of the SUCCESS paths above and use it in the next step.</p>";
?>