<?php
// HTPasswd Generator for watchevents.shop
$username = 'admin';
$password = 'admin'; // CHANGE THIS PASSWORD!

// Your exact path from get-path.php
$htpasswd_path = '/home/admin/public_html/acadlib.com/app-panel/.htpasswd';

echo "<h2>Creating .htpasswd File</h2>";
echo "<p><strong>Path:</strong> " . $htpasswd_path . "</p>";

// Generate the password hash
$hash = password_hash($password, PASSWORD_BCRYPT);
$htpasswd_content = $username . ':' . $hash;

echo "<h3>Your Login Details:</h3>";
echo "<p><strong>Username:</strong> " . $username . "</p>";
echo "<p><strong>Password:</strong> " . $password . "</p>";

// Create the file
if (file_put_contents($htpasswd_path, $htpasswd_content)) {
    echo "<p style='color: green; font-size: 18px;'>✅ SUCCESS! .htpasswd file created!</p>";
    
    // Verify
    if (file_exists($htpasswd_path)) {
        $content = file_get_contents($htpasswd_path);
        echo "<p>File verified: " . (trim($content) === $htpasswd_content ? "✅ GOOD" : "❌ BAD") . "</p>";
    }
} else {
    echo "<p style='color: red; font-size: 18px;'>❌ FAILED to create file</p>";
    echo "<p>Manual creation required. Add this line to " . $htpasswd_path . ":</p>";
    echo "<pre style='background: yellow; padding: 10px;'>" . $htpasswd_content . "</pre>";
}

echo "<hr>";
echo "<h3>Next Steps:</h3>";
echo "<ol>";
echo "<li>Create the .htaccess file in your admin folder (see next file)</li>";
echo "<li>Test login at: https://watchevents.shop/app-panel/admin/</li>";
echo "<li>Use username: <strong>admin</strong>, password: <strong>" . $password . "</strong></li>";
echo "<li><strong style='color: red;'>DELETE this file after success!</strong></li>";
echo "</ol>";
?>